ZPreview
========

I had trouble getting [rpVT](http://www.ztwiki.com/rpVT) to run again, and I needed to be able to preview other file formats (such as PDF) as well; especially now that Windows Explorer also supports all kinds of file format previews. So I wrote my own previewer ZAAP.

Usage
-----
As with any [ZAAP](http://www.ztree.com/html/zaap.htm), it requires an instance of ZTreeWin to be started with the /ZB command-line option.
Just run ZPreview.exe, and it should automatically find ZTreeWin and the `zbar.dat` file. If the file is not found, it will ask for its location.

The previewer attempts to display the currently highlighted file according to the following methods:

1. Load and display the file as a graphic image using Delphi's internal graphic routines.
2. Load and display the file as a graphic image using the [FreeImage](http://freeimage.sourceforge.net/) library (not in Win64 version);
3. Use the registered [Windows Preview Handler](doc/WindowsPreviewHandlers.md) for that file type;
4. Use the loaded Total Commander WLX [Lister plugin](http://www.totalcmd.net/directory/lister.html) (you need to load one or more first, using Ctrl+L);
5. Display the file's textual contents, if its [perceived type](https://msdn.microsoft.com/en-us/library/windows/desktop/cc144150.aspx) is 'text'.
6. Load and display the file's thumbnail from the Windows Shell [Thumbnail Cache](http://en.wikipedia.org/wiki/Windows_thumbnail_cache).
7. Load and display the file's icon.

_The current toolbar buttons_:

* __Refresh__: reads the `zbar.dat` interface, and refreshes the preview
* __Autorefresh__: continually reads the `zbar.dat` interface, and refreshes the preview on every change. This tends to make the preview a bit less responsive (it doesn't affect ZTreeWin)
* __ZTreeWin__: activates the ZTreeWin window
* __Properties__: opens the currently selected file's properties dialog
* __File Info__: shows a popup window containing some metadata about the current file.
* __Sentinel__: shows a popup window containing the current information in the `zbar.dat` file
* __Full Screen__: hides the window's title bar and toolbar, so more of the preview is visible. Return to normal by pressing the Escape key, or Ctrl+Shift+F.
* __Stay on Top__: keeps the preview window in the foreground and on top of other windows, even when it is not the active window. This allows you to keep using ZTreeWin to navigate while the preview is being displayed.
* __Preview Engine__: clicking the arrow will display the list of preview engines (and all the renderers supported by each engine — each renderer will indicate that it's supposed to work for the current file by showing a check mark in its menu item). Bold indicates the preview engine (and renderer) that are displaying the current file.
  Clicking the button (or pressing Ctrl+Shift+F7) will select the next available renderer for the current file.
* __(buttons with preview engines)__: click disable or enable each preview engine (including all its renderers)


_The current keyboard shortcuts from within ZTreeWin_:

* Ctrl-Shift-F4: closes ZPreview
* Ctrl-Shift-R: refreshes the preview
* Ctrl-Shift-M: minimizes/unminimizes the ZPreview window
* Ctrl-Shift-I: toggles the 'File Info' toolwindow
* Ctrl-Shift-S: toggles the 'Sentinel Info' toolwindow
* Ctrl-Shift-F: toggles full screen view
* Ctrl-Shift-F7: selects the next available preview renderer

Known problems
--------------
* ZPreview doesn’t remember any of its settings.
* Currently, the preview window starts in a default position, so you'll probably have to move it out of the way -- it doesn't save its window positions for next time, either.
* Leaving open the File Info window while navigating will generate errors in the FreeImage library.
* Activating a different window (such as ZTreeWin) will hide the tool windows (File Info and/or Sentinel Info). Pressing the relevant keyboard shortcut in ZTreeWin *twice* will cause them to re-appear.
* A few Windows Preview Handlers generate errors, but most of them work properly (even if they can be slow to load).
* Once loaded, it's not possible to unload WLX plugins, except by restarting ZPreview: it also does not remember which plugins to reload.
* WLX plugins have not been tested very much at all, so it is very well possible that many of them do not work properly.
* Some renderers also work with files that they don't report to work with, and vice versa.
* See also the full [list of tickets](../../../rptview?rn=1).
* If you're running into a problem, and it's not listed here, nor is there a ticket for it, may I suggest that you [create a ticket](../../../tktnew) for it?

Download
--------
The 32- and 64-bit versions of ZPreview can be [downloaded](../../../zip/zpreview.zip?uuid=zpreview) from this site.

The (Delphi) [source code](../../../tree/ZPreview?type=tree&ci=trunk&expand) can be browsed on this site, or downloaded in [a single zip file](../../../zip/zpreview-src.zip?uuid=trunk).

Note that either the 32- and 64-bits version can be used with both the 32- and 64-bits versions of ZTreeWin. They're separate programs, so the difference in bitness doesn't matter. I made both versions because 64-bits is the future, but FreeImage only distributes a 32-bits DLL by default.

What's new
----------
#### Version [v1.0.2.0](../../../zip/zpreview-1.0.2.0.zip?uuid=zpreview-1.0.2.0) (2015-02-16)
* Rewrite of the internal structure, so all ‘preview engines’ can be enabled and disabled separately.
* Each engine now has its own window (internally), so most Windows Preview Handlers now work correctly.
* Added UI buttons to manually choose an engine and renderer to preview the current file with.
* Added button to open the current file’s properties window.
* Multiple WLX plugins can now be loaded at will (though they’re not automatically reload on startup).
* Both info windows are less translucent.
* Added status bar to show the current file’s icon, the currently selected renderer, and some basic info about the current file.
* The File Info window now always displays the current file’s attributes
* For reparse points (junctions, symbolic links, etc.) the target file name is also displayed
* Added the following preview engines:
  - Text (rich text, plain text)
  - Shell Item Images (thumbnail, file’s icon)

Old versions
------------
#### Version [v1.0.1.0](../../../zip/zpreview-1.0.1.0.zip?uuid=zpreview-1.0.1.0) (2015-02-06)
* Simplified the toolbar;
* Added buttons for Full Screen, Stay on Top and loading of a WLX plugin.
* GIF files are now animated (if they contain animations).
* Improved handling of errors.
* The 'Image Info' window was renamed to File Info; it can now also show (very summary) information about files when not using FreeImage.
* More Windows Preview handlers are now detected and used (ticket [36202cb36a](../../../info/36202cb36a)).
* When `zbar.dat` can not be found automatically, look explicitly in `%APPDATA%\ZTreeWin`; failing that, ask the user (ticket [ed86fb95ef](../../../info/ed86fb95ef)).

#### Version [1.0.0.1](../../../zip/zpreview-1.0.0.0.zip?uuid=zpreview-1.0.0.0) (2015-02-03)
The 32-bit version can be downloaded from [http://martijn.coppoolse.com/upload/ZPreview_v1.0.0.1_w32.zip](http://martijn.coppoolse.com/upload/ZPreview_v1.0.0.1_w32.zip) (uses FreeImage.dll to display images).
The 64-bit version can be downloaded from [http://martijn.coppoolse.com/upload/ZPreview_v1.0.0.1_w64.zip](http://martijn.coppoolse.com/upload/ZPreview_v1.0.0.1_w64.zip) (uses Delphi's —slower— internal routines to preview images).


Future plans
------------
* Fix the known problems listed above
* Support for navigation shortcut keys from ZTreeWin:
  - zooming in/out of images, and scrolling
  - scrolling through PDF preview (if possible)
* Provide UI to indicate a preferred order when automatically selecting a renderer to be used
* Provide UI to associate a specific renderer with one or more file specification(s)
* Include an (automatic) update mechanism


`-- `
Martijn
