unit U_LogEmitter;

interface

type
  TLogLevel = (
    llError = 0,
    llWarning = 1,
    llHint = 2,
    llInfo = 3,
    llDebug = 4
  );

  TLogEvent = procedure(Sender: TObject; Text: string; LogLevel: TLogLevel = llInfo; IndentLevel: integer = 0) of object;

  TLogEmitter = class
    protected
      FOnLog: TLogEvent;

      procedure WriteToLog(Text: string; LogLevel: TLogLevel = llInfo;
                            IndentLevel: integer = 0); virtual;
      procedure TransferLog(Sender: TObject; Text: string; LogLevel:
                            TLogLevel = llInfo; IndentLevel: integer = 0); virtual;
    public
      property OnLog: TLogEvent   read FOnLog write FOnLog;
  end;

implementation

{ ============================================================================ }
{ TLogEmitter }

{ ---------------------------------------------------------------------------- }
procedure TLogEmitter.TransferLog(Sender: TObject; Text: string;
  LogLevel: TLogLevel; IndentLevel: integer);
begin
  if Assigned(FOnLog) then begin
    FOnLog(Sender, Text, LogLevel, IndentLevel);
  end;
end;

{ ---------------------------------------------------------------------------- }
procedure TLogEmitter.WriteToLog(Text: string; LogLevel: TLogLevel;
  IndentLevel: integer);
begin
  TransferLog(Self, Text, LogLevel, IndentLevel);
end;

end.
