unit listplug; { Contents of file listplug.pas }

interface

const
  LC_COPY = 1;
  LC_NEWPARAMS = 2;
  LC_SELECTALL = 3;
  LC_SETPERCENT = 4;
  LCP_WRAPTEXT = 1;
  LCP_FITTOWINDOW = 2;
  LCP_ANSI = 4;
  LCP_ASCII = 8;
  LCP_VARIABLE = 12;
  LCP_FORCESHOW = 16;
  LCP_FITLARGERONLY = 32;
  LCP_CENTER = 64;
  LCS_FINDFIRST = 1;
  LCS_MATCHCASE = 2;
  LCS_WHOLEWORDS = 4;
  LCS_BACKWARDS = 8;
  ITM_PERCENT = $FFFE;
  ITM_FONTSTYLE = $FFFD;
  ITM_WRAP = $FFFC;
  ITM_FIT = $FFFB;
  ITM_NEXT = $FFFA;
  ITM_CENTER = $FFF9;
  LISTPLUGIN_OK = 0;
  LISTPLUGIN_ERROR = 1;

type
  TListDefaultParamStruct = record
    size,
    PluginInterfaceVersionLow,
    PluginInterfaceVersionHi: longint;
    DefaultIniName: array[0..MAX_PATH-1] of char;
  end;
  PListDefaultParamStruct = ^TListDefaultParamStruct;

{ Function prototypes: Functions need to be defined exactly like this!}

(*
function ListLoad(ParentWin: THandle; FileToLoad: PAnsiChar; ShowFlags: integer): THandle; stdcall;
function ListLoadW(ParentWin: THandle; FileToLoad: PWideChar; ShowFlags: integer): THandle; stdcall;
function ListLoadNext(ParentWin, PluginWin: THandle; FileToLoad: PAnsiChar; ShowFlags: integer): integer; stdcall;
function ListLoadNextW(ParentWin, PluginWin: THandle; FileToLoad: PWideChar; ShowFlags: integer): integer; stdcall;
procedure ListCloseWindow(ListWin: THandle); stdcall;
procedure ListGetDetectString(DetectString: PAnsiChar; MaxLen: integer); stdcall;
function ListSearchText(ListWin: THandle; SearchString: PAnsiChar;
                        SearchParameter: integer): integer; stdcall;
function ListSearchTextW(ListWin: THandle; SearchString: PWideChar;
                        SearchParameter: integer): integer; stdcall;
function ListSearchDialog(ListWin: THandle; FindNext: integer): integer; stdcall;
function ListSendCommand(ListWin: THandle; Command, Parameter: integer): integer; stdcall;
function ListPrint(ListWin: THandle; FileToPrint, DefPrinter: PAnsiChar;
                   PrintFlags: integer; var Margins: TRect): integer; stdcall;
function ListPrintW(ListWin: THandle; FileToPrint, DefPrinter: PWideChar;
                   PrintFlags: integer; var Margins: TRect): integer; stdcall;
{$IFDEF WIN64}
function ListNotificationReceived(ListWin: THandle; Message: integer; wParam: WPARAM; lParam: LPARAM): integer; stdcall;
{$ELSE}
function ListNotificationReceived(ListWin: THandle; Message: integer; wParam, lParam: integer): integer; stdcall;
{$ENDIF}
procedure ListSetDefaultParams(dps: PListDefaultParamStruct); stdcall;
function ListGetPreviewBitmap(FileToLoad: PAnsiChar; Width, Height: integer;
    contentbuf: PAnsiChar; contentbuflen: integer): hBitmap; stdcall;
function ListGetPreviewBitmapW(FileToLoad: PWideChar; Width, Height: integer;
    contentbuf: PAnsiChar; contentbuflen: integer): hBitmap; stdcall;
*)

  TWxListLoad = function(ParentWin: THandle; FileToLoad: PAnsiChar; ShowFlags: integer): THandle; stdcall;
  TWxListLoadW = function(ParentWin: THandle; FileToLoad: PWideChar; ShowFlags: integer): THandle; stdcall;
  TWxListLoadNext = function(ParentWin, PluginWin: THandle; FileToLoad: PAnsiChar; ShowFlags: integer): integer; stdcall;
  TWxListLoadNextW = function(ParentWin, PluginWin: THandle; FileToLoad: PWideChar; ShowFlags: integer): integer; stdcall;
  TWxListCloseWindow = procedure(ListWin: THandle); stdcall;
  TWxListGetDetectString = procedure(DetectString: PAnsiChar; MaxLen: integer); stdcall;
  TWxListSearchText = function(ListWin: THandle; SearchString: PAnsiChar;
                          SearchParameter: integer): integer; stdcall;
  TWxListSearchTextW = function(ListWin: THandle; SearchString: PWideChar;
                          SearchParameter: integer): integer; stdcall;
  TWxListSearchDialog = function(ListWin: THandle; FindNext: integer): integer; stdcall;
  TWxListSendCommand = function(ListWin: THandle; Command, Parameter: integer): integer; stdcall;
  TWxListPrint = function(ListWin: THandle; FileToPrint, DefPrinter: PAnsiChar;
                     PrintFlags: integer; var Margins: TRect): integer; stdcall;
  TWxListPrintW = function(ListWin: THandle; FileToPrint, DefPrinter: PWideChar;
                     PrintFlags: integer; var Margins: TRect): integer; stdcall;
  {$IFDEF WIN64}
  TWxListNotificationReceived = function(ListWin: THandle; Message: integer; wParam: WPARAM; lParam: LPARAM): integer; stdcall;
  {$ELSE}
  TWxListNotificationReceived = function(ListWin: THandle; Message: integer; wParam, lParam: integer): integer; stdcall;
  {$ENDIF}
  TWxListSetDefaultParams = procedure(dps: PListDefaultParamStruct); stdcall;
  TWxListGetPreviewBitmap = function(FileToLoad: PAnsiChar; Width, Height: integer;
      contentbuf: PAnsiChar; contentbuflen: integer): hBitmap; stdcall;
  TWxListGetPreviewBitmapW = function(FileToLoad: PWideChar; Width, Height: integer;
      contentbuf: PAnsiChar; contentbuflen: integer): hBitmap; stdcall;

implementation
end.