unit F_PE_WlxPlugins;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, System.Actions,
  Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ActnList, Vcl.StdActns, Vcl.ExtCtrls,
  U_PreviewEngine;

type
  TfrmPEWlxPlugins = class(TCustomPreviewEngineForm)
    aclWlxPlugins: TActionList;
    actPluginLoad: TFileOpen;
    imgPreview: TImage;
    procedure actPluginLoadAccept(Sender: TObject);
  private
    { Private declarations }
  protected
    function GetActionList: TActionList; override;
  public
    { Public declarations }
    procedure Clear; override;

    function LoadPlugin(const WlxFileName: string): TRenderer;
  end;

var
  frmPEWlxPlugins: TfrmPEWlxPlugins;

implementation
uses
  WlxPluginWrapper,
  M_Main;

{$R *.dfm}

type
  TWlxRenderer = class(TRenderer)
  private
    FWlxPlugin: TWlxPluginWrapper;
    FCanLoad: Boolean;
    FCanGenerateBitmap: Boolean;
    FDetectString: string;
  public
    constructor Create(const Parent: TCustomPreviewEngineForm;
                       const FileName: string);
    destructor  Destroy; override;

    function  CouldShowFile(const FileName: string): boolean; override;
    function  TryShowFile(const FileName: string): boolean; override;
    procedure PopulateInfo(const Lines: IInfoLineDisplayer); override;
//    function  SummarizeInfo: string; override;
  end;

{ ================================================================================================ }
{ TfrmPEWlxPlugins }

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmPEWlxPlugins.Clear;
begin
  inherited;
  {$MESSAGE HINT 'TODO: TfrmPEWlxPlugins.Clear'}
end {TfrmPEWlxPlugins.Clear};

{ ------------------------------------------------------------------------------------------------ }
function TfrmPEWlxPlugins.GetActionList: TActionList;
begin
  Result := aclWlxPlugins;
end {TfrmPEWlxPlugins.GetActionList};

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmPEWlxPlugins.actPluginLoadAccept(Sender: TObject);
var
  WlxFile: string;
begin
  for WlxFile in actPluginLoad.Dialog.Files do begin
    LoadPlugin(WlxFile);
  end;
end {TfrmPEWlxPlugins.actPluginLoadAccept};

{ ------------------------------------------------------------------------------------------------ }
function TfrmPEWlxPlugins.LoadPlugin(const WlxFileName: string): TRenderer;
begin
  Result := TWlxRenderer.Create(Self, WlxFileName);
  FRenderers.Add(Result);
end {TfrmPEWlxPlugins.LoadPlugin};



{ ------------------------------------------------------------------------------------------------ }
{ TWlxRenderer }

{ ------------------------------------------------------------------------------------------------ }
constructor TWlxRenderer.Create(const Parent: TCustomPreviewEngineForm; const FileName: string);
var
  IniFileName: string;
begin
  inherited Create(Parent, FileName);
  {$MESSAGE WARN 'TODO: pass the correct .ini file path!'}
  IniFileName := '';
  FWlxPlugin := TWlxPluginWrapper.Create(Parent.Handle, FileName, IniFileName);
  FCanLoad := Assigned(FWlxPlugin.Methods.ListLoadW) or Assigned(FWlxPlugin.Methods.ListLoad);
  FCanGenerateBitmap := Assigned(FWlxPlugin.Methods.ListGetPreviewBitmapW) or Assigned(FWlxPlugin.Methods.ListGetPreviewBitmap);
  FDetectString := FWlxPlugin.GetDetectString;
end {TWlxRenderer.Create};
{ ------------------------------------------------------------------------------------------------ }
destructor TWlxRenderer.Destroy;
begin
  FWlxPlugin.Free;
  inherited;
end {TWlxRenderer.Destroy};

{ ------------------------------------------------------------------------------------------------ }
function TWlxRenderer.CouldShowFile(const FileName: string): boolean;
begin
  {$MESSAGE HINT 'TODO: use the DetectString to see if we could show this file'}
  Result := FCanLoad or FCanGenerateBitmap;
end {TWlxRenderer.CouldShowFile};

{ ------------------------------------------------------------------------------------------------ }
function TWlxRenderer.TryShowFile(const FileName: string): boolean;
var
  hBmp: HBITMAP;
begin
  Result := False;
  if FCanLoad then begin
    TfrmPEWlxPlugins(Form).imgPreview.Visible := False;
    if SameFileName(FileName, FWlxPlugin.LoadedFilename) then
      Result := FWlxPlugin.LoadNext(FileName, 0)
    else
      Result := 0 <> FWlxPlugin.Load(FileName, 0);
  end;
  if (Result = False) and FCanGenerateBitmap then begin
    hBmp := FWlxPlugin.GetPreviewBitmap(FileName, Form.ClientWidth, Form.ClientHeight);
    Result := hBmp <> 0;
    if Result then begin
      TfrmPEWlxPlugins(Form).imgPreview.Picture.Bitmap.Handle := hBmp;
      TfrmPEWlxPlugins(Form).imgPreview.Visible := True;
    end;
  end;
  if (Result = False) then begin
    TfrmPEWlxPlugins(Form).imgPreview.Visible := False;
    Result := False;
  end;
end {TWlxRenderer.TryShowFile};

{ ------------------------------------------------------------------------------------------------ }
procedure TWlxRenderer.PopulateInfo(const Lines: IInfoLineDisplayer);
begin
  inherited;
  Lines.Add('Lister plugin', 'Detection string', FDetectString);
end {TWlxRenderer.PopulateInfo};




////////////////////////////////////////////////////////////////////////////////////////////////////
initialization
  TCustomPreviewEngineForm.RegisterForm(TfrmPEWlxPlugins);

end.
