unit F_Info;

interface

uses
  System.Classes,
  Vcl.Forms, Vcl.Controls, Vcl.ComCtrls, Vcl.Graphics
  {$IFDEF WIN32},
  FreeBitmap, FreeImage
  {$ENDIF},
  U_PreviewEngine, Vcl.Menus, System.Actions, Vcl.ActnList;

type
  TfrmInfo = class(TForm, IInfoLineDisplayer)
    lvwFields: TListView;
    pumInfo: TPopupMenu;
    aclInfo: TActionList;
    actCopySelected: TAction;
    miCopyValues: TMenuItem;
    actCopyAll: TAction;
    Copy1: TMenuItem;
    procedure FormShowHide(Sender: TObject);
    procedure actCopySelectedExecute(Sender: TObject);
    procedure actCopyAllExecute(Sender: TObject);
  private
    { Private declarations }
    function GroupID(const GroupHeader: string): integer;

    procedure Add(const Group, Name, Value, Chars: string); overload;
    procedure Add(const Group, Name: string; const Value: Integer); overload;
    procedure Add(const Group, Name, Prefix: string; const Value: Integer); overload;
    procedure Add(const Group, Name: string; const Value: AnsiChar); overload;
    procedure Add(const Group, Name: string; const Value: string); overload;
    procedure Add(const Group, Name: string; const Value: Integer; const Names: array of string); overload;

    procedure PopulateFileName(const Filename: string);
    procedure AutosizeColumns;
  public
    { Public declarations }
    procedure StartPopulatingLines(const Filename: string; const Clear: boolean = False);
    procedure PopulateLine(const Group, Key, Short, Long: string);
    procedure StopPopulatingLines;
  end;

var
  frmInfo: TfrmInfo;

implementation

uses
  SysUtils, System.TypInfo,
  Winapi.Windows,
  Vcl.Clipbrd, Vcl.Imaging.GIFImg, Vcl.Imaging.jpeg, Vcl.Imaging.pngimage,
  FJunction,
  M_Main, F_Main;

{$R *.dfm}

{ ================================================================================================ }
{ TfrmInfo }

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.FormShowHide(Sender: TObject);
begin
  frmMain.ActionManager.FindItemByAction(frmMain.actViewImageInfo).Action.Checked := Visible;
  AlphaBlend := True;
end;

{ ------------------------------------------------------------------------------------------------ }
function TfrmInfo.GroupID(const GroupHeader: string): integer;
var
  i: Integer;
begin
  for i := 0 to lvwFields.Groups.Count - 1 do begin
    if SameText(GroupHeader, lvwFields.Groups[i].Header) then begin
      Result := i;
      Exit;
    end;
  end;
  with lvwFields.Groups.Add do begin
    Header := GroupHeader;
    Result := Index;
    State := [lgsNormal];
  end;
end {TfrmInfo.GroupID};

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.Add(const Group, Name, Value, Chars: string);
var
  Item: TListItem;
begin
  Item := lvwFields.Items.Add;
  Item.GroupID := GroupID(Group);
  Item.Caption := Name;
  Item.SubItems.Add(Value);
  Item.SubItems.Add(Chars);
end;
{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.Add(const Group, Name: string; const Value: Integer);
begin
  Add(Group, Name, '', IntToStr(Value));
end;
{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.Add(const Group, Name, Prefix: string; const Value: Integer);
begin
  Add(Group, Name, Prefix, IntToStr(Value));
end;
{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.Add(const Group, Name: string; const Value: AnsiChar);
begin
  Add(Group, Name, IntToStr(Ord(Value)), string(Value));
end;
{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.Add(const Group, Name, Value: string);
begin
  Add(Group, Name, '(' + IntToStr(Length(Value)) + ')', Value);
end;
{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.Add(const Group, Name: string; const Value: Integer; const Names: array of string);
begin
  Add(Group, Name, IntToStr(Value), Names[Value]);
end {TfrmInfo.Add};

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.actCopyAllExecute(Sender: TObject);
var
  Lines: TStringList;
  GroupID: integer;
  Item: TListItem;
  Line, Value: string;
  Group: TListGroup;
begin
  Lines := TStringList.Create;
  try
    GroupID := -1;
    for Item in lvwFields.Items do begin
      if Item.GroupID <> GroupID then begin
        Group := lvwFields.Groups.FindItemID(Item.GroupID) as TListGroup;
        if Assigned(Group) then
          Lines.Add('[' + Group.Header + ']');
        GroupID := Item.GroupID;
      end;
      Line := Item.Caption;
      for Value in Item.SubItems do
        Line := Line + #9 + Value;
      Lines.Add(Line);
    end;
    Clipboard.AsText := Lines.Text;
  finally
    Lines.Free;
  end;
end {TfrmInfo.actCopyAllExecute};

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.actCopySelectedExecute(Sender: TObject);
var
  Lines: TStringList;
  i: Integer;
begin
  Lines := TStringList.Create;
  try
    for i := 0 to lvwFields.Items.Count - 1 do begin
      if lvwFields.Items[i].Selected then begin
        if lvwFields.Items[i].SubItems.Count > 1 then begin
          Lines.Add(lvwFields.Items[i].SubItems[1]);
        end else begin
          Lines.Add('')
        end;
      end;
    end;
    Clipboard.AsText := Lines.Text.TrimRight;
  finally
    Lines.Free;
  end;
end {TfrmInfo.actCopyExecute};

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.PopulateFileName(const Filename: string);
const
//  csAttr: array[Boolean] of string = ('drashceijnoptuv',
//                                      'DRASHCEIJNOPTUV');
  csAttr: array[Boolean] of string = ('',
                                      'drashceijnoptuv');
  cAttr: array[1..15] of integer = (FILE_ATTRIBUTE_DIRECTORY,
                                    FILE_ATTRIBUTE_READONLY,
                                    FILE_ATTRIBUTE_ARCHIVE,
                                    FILE_ATTRIBUTE_SYSTEM,
                                    FILE_ATTRIBUTE_HIDDEN,
                                    FILE_ATTRIBUTE_COMPRESSED,
                                    FILE_ATTRIBUTE_ENCRYPTED,
                                    FILE_ATTRIBUTE_NOT_CONTENT_INDEXED,
                                    FILE_ATTRIBUTE_REPARSE_POINT,
                                    FILE_ATTRIBUTE_NORMAL,
                                    FILE_ATTRIBUTE_OFFLINE,
                                    FILE_ATTRIBUTE_SPARSE_FILE,
                                    FILE_ATTRIBUTE_TEMPORARY,
                                    FILE_ATTRIBUTE_VIRTUAL,
                                    FILE_ATTRIBUTE_DEVICE);
  csAttrName: array[1..15] of string = ('directory',
                                        'readonly',
                                        'archive',
                                        'system',
                                        'hidden',
                                        'compressed',
                                        'encrypted',
                                        'not content indexed',
                                        'reparse point',
                                        'normal',
                                        'offline',
                                        'sparse file',
                                        'temporary',
                                        'virtual',
                                        'device');
  { - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - }
  function GetAttributesString(const Attr: Integer): string;
  var
    i: Integer;
  begin
    for i := Low(cAttr) to High(cAttr) do begin
      if (Attr and cAttr[i]) <> 0 then begin
        if Length(Result) > 0 then
          Result := Result + ', ';
        Result := Result + csAttrName[i];
      end;
    end;
    Result := StringOfChar('.', Length(cAttr)) + ' [' + Result + ']';
    for i := Low(cAttr) to High(cAttr) do begin
      Result[i] := csAttr[(Attr and cAttr[i]) <> 0][i];
    end;
  end {GetAttributesString};
  { - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - }
var
  Attr: Integer;
  Target: WideString;
  LinkType: TReparsePointType;
begin
  Add(Filename, 'File name', ExtractFileName(Filename));
  Add(Filename, 'File path', ExtractFilePath(Filename));
  Attr := FileGetAttr(FileName, False);
  Add(Filename, 'Attributes', '0x' + IntToHex(Attr, 2), GetAttributesString(Attr));
  if ((Attr and faSymLink) <> 0) and FJunction.FGetSymlinkInfo(Filename, Target, LinkType) then begin
    Add(Filename, SReparsePointType[LinkType] + ' target', Target);
  end;
end {TfrmInfo.PopulateFileName};

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.PopulateLine(const Group, Key, Short, Long: string);
var
  Item: TListItem;
begin
  Item := lvwFields.Items.Add;
  Item.Caption := Key;
  Item.SubItems.Add(Short);
  Item.SubItems.Add(Long);
end {TfrmInfo.PopulateLines};

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.StartPopulatingLines(const Filename: string; const Clear: boolean);
begin
  lvwFields.Items.BeginUpdate;
  if Clear then
    lvwFields.Items.Clear;
  PopulateFileName(Filename);
end {TfrmInfo.StartPopulatingLines};

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.StopPopulatingLines;
begin
  AutosizeColumns;
  lvwFields.Items.EndUpdate;
end {TfrmInfo.StopPopulatingLines};

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfo.AutosizeColumns;
var
  Column: TCollectionItem;
begin
  for Column in lvwFields.Columns do
    TListColumn(Column).Width := -2;
end {TfrmInfo.AutosizeColumns};

end.
