unit F_PE_ShellItemImages;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ExtCtrls,
  U_PreviewEngine;

type
  TfrmPEShellItemImages = class(TCustomPreviewEngineForm)
    imgPreview: TImage;
  private
    { Private declarations }
  protected
    function GetRenderers: TRendererList; override;
  public
    { Public declarations }
    procedure Clear; override;
  end;

var
  frmPEShellItemImages: TfrmPEShellItemImages;

implementation
uses
  System.Math,
  Winapi.ShlObj,
  U_ShellItemImage;

{$R *.dfm}

type
  { ------------------------------------------------------------------------------------------------ }
  TShellImageRenderer = class(TRenderer)
  private
    FFlags: integer;
  public
    constructor Create(const Parent: TCustomPreviewEngineForm;
                       const Name: string;
                       const Flags: integer);
    function  CouldShowFile(const FileName: string): boolean; override;
    function  TryShowFile(const FileName: string): boolean; override;
    procedure PopulateInfo(const InfoLines: IInfoLineDisplayer); override;
  end {TGraphicRenderer};



{ ================================================================================================ }
{ TfrmPEShellItemImages }

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmPEShellItemImages.Clear;
begin
  inherited;
  imgPreview.Picture.Graphic := nil;
end;

{ ------------------------------------------------------------------------------------------------ }
function TfrmPEShellItemImages.GetRenderers: TRendererList;
begin
  Result := inherited GetRenderers;
  if Result.Count = 0 then begin
    Result.Add(TShellImageRenderer.Create(Self, 'Thumbnail', SIIGBF_THUMBNAILONLY));
    Result.Add(TShellImageRenderer.Create(Self, 'File Icon', SIIGBF_ICONONLY));
  end;
end {TfrmPEShellItemImages.GetRenderers};

{ ================================================================================================ }
{ TShellImageRenderer }

{ ------------------------------------------------------------------------------------------------ }
constructor TShellImageRenderer.Create(const Parent: TCustomPreviewEngineForm;
                                       const Name: string;
                                       const Flags: integer);
begin
  inherited Create(Parent, Name);
  FFlags := Flags;
end {TShellImageRenderer.Create};

{ ------------------------------------------------------------------------------------------------ }
function TShellImageRenderer.CouldShowFile(const FileName: string): boolean;
begin
  {$MESSAGE HINT 'TODO: Is there any way to know if we could generate a thumbnail?  MCO 10-02-2015'}
  Result := True;
end {TShellImageRenderer.CouldShowFile};

{ ------------------------------------------------------------------------------------------------ }
function TShellImageRenderer.TryShowFile(const FileName: string): boolean;
var
  Form: TfrmPEShellItemImages;
  hBmp: HBITMAP;
  Width, Height: Integer;
begin
  Form := Self.Form as TfrmPEShellItemImages;
  Width := Form.imgPreview.ClientWidth;
  Height := Form.imgPreview.ClientHeight;
  if (FFlags and SIIGBF_ICONONLY) <> 0 then begin
    if Width > Height then
      Width := Height
    else
      Height := Width;
  end;
  Result := Succeeded(GetFileImage(FileName, Width, Height, FFlags, hBmp));
  if Result then begin
    with Form.imgPreview.Picture.Bitmap do begin
      TransparentMode := tmAuto;
      AlphaFormat := afDefined;
      Handle := hBmp;
    end;
  end;
end {TShellImageRenderer.TryShowFile};

{ ------------------------------------------------------------------------------------------------ }
procedure TShellImageRenderer.PopulateInfo(const InfoLines: IInfoLineDisplayer);
begin
  inherited;
end {TShellImageRenderer.PopulateInfo};




////////////////////////////////////////////////////////////////////////////////////////////////////
initialization
  TCustomPreviewEngineForm.RegisterForm(TfrmPEShellItemImages);

end.
