unit F_Sentinel;

interface

uses
  Forms, System.Classes, Vcl.Controls, Vcl.ComCtrls,
  U_ZaapSentinel2;

type
  TfrmInfoSentinel = class(TForm)
    lvwFields: TListView;
    procedure FormActivate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormShowHide(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Populate(const Sentinel: TZaapSentinelFile);
    procedure PopulateProblems(const Sentinel: TZaapSentinelFile; const ClearFirst: Boolean);
  end;

var
  frmInfoSentinel: TfrmInfoSentinel;

implementation

uses
  SysUtils,
  F_Main, M_Main;

{$R *.dfm}

{ ================================================================================================ }
{ TfrmSentinelInfo }

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfoSentinel.FormActivate(Sender: TObject);
begin
//  AlphaBlend := False;
end;

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfoSentinel.FormDeactivate(Sender: TObject);
begin
  AlphaBlend := True;
end;

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfoSentinel.FormShowHide(Sender: TObject);
begin
  frmMain.ActionManager.FindItemByAction(frmMain.actViewSentinel).Action.Checked := Visible;
  AlphaBlend := True;
end;

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfoSentinel.Populate(const Sentinel: TZaapSentinelFile);
var
  LGroupID: integer;
  function AddRow(const Name, Value, Chars: string): TListItem; overload;
  begin
    Result := lvwFields.Items.Add;
    Result.GroupID := LGroupID;
    Result.Caption := Name;
    Result.SubItems.Add(Value);
    Result.SubItems.Add(Chars);
  end;
  function AddRow(const Name: string; const Value: Cardinal): TListItem; overload;
  begin
    Result := AddRow(Name, IntToStr(Value), '');
  end;
  function AddRow(const Name: string; const Value: AnsiChar): TListItem; overload;
  begin
    Result := AddRow(Name, IntToStr(Ord(Value)), string(Value));
  end;
  function AddRow(const Name: string; const Value: string): TListItem; overload;
  begin
    Result := AddRow(Name, '(' + IntToStr(Length(Value)) + ')', Value);
  end;
  function AddRow(const Name: string; const Value: byte): TListItem; overload;
  begin
    Result := AddRow(Name, Cardinal(Value));
  end;
  function AddRow(const Name: string; const Values: array of byte): TListItem; overload;
  var
    B: Byte;
    Value: string;
  begin
    Value := '';
    for B in Values do
      Value := Value + IntToHex(B, 2) + ' ';
    Value := TrimRight(Value);
    Result := AddRow(Name, '(' + IntToStr(Length(Values)) + ')', Value);
  end;
var
  Column: TCollectionItem;
  Buffer: array[0..1023] of Char;
  BufferSize: integer;
begin
  lvwFields.Items.BeginUpdate;
  try
    lvwFields.Clear;
    LGroupID := 0;
    lvwFields.Groups[LGroupID].Header := Sentinel.Filename;
    try
      AddRow('Sequence', Sentinel.Pamphlet.Sequence);
      AddRow('HWnd',     '0x'+IntToHex(Sentinel.Pamphlet.HWnd, 4), IntToStr(Sentinel.Pamphlet.HWnd));
      AddRow('Handshake', Sentinel.Pamphlet.Handshake);
      AddRow('Screen status', Sentinel.Pamphlet.ScreenStatus);
      AddRow('Command', Sentinel.Pamphlet.Command);
      AddRow('Command char', Sentinel.Pamphlet.CommandChar);
      AddRow('Page', Sentinel.Pamphlet.Page);
      AddRow('Block size', Sentinel.Pamphlet.BlockSize);
      AddRow('Revision', Sentinel.Pamphlet.Revision);
      AddRow('Stats', Sentinel.Pamphlet.Stats);
      AddRow('(reserved)', Sentinel.Pamphlet.Reserved1);
      AddRow('This path', Sentinel.ThisPath);
      AddRow('Other path', Sentinel.OtherPath);
      AddRow('Entry line', Sentinel.EntryLine);
      AddRow('Checksum', '0x'+IntToHex(Sentinel.Checksum, 4), IntToStr(Sentinel.Checksum));
      AddRow('Sequence', Sentinel.CheckSeq);
      if Sentinel.HasProblem then begin
        PopulateProblems(Sentinel, False);
      end;
    except
      BufferSize := ExceptionErrorMessage(ExceptObject, ExceptAddr, Buffer, Length(Buffer));
      with lvwFields.Items.Add do begin
        GroupID := 1;
        SubItems.Add('');
        SubItems.Add(Copy(Buffer, 1, BufferSize));
      end;
    end;
    for Column in lvwFields.Columns do begin
      TListColumn(Column).Width := -2;
    end;
  finally
    lvwFields.Items.EndUpdate;
  end;
end {TfrmSentinelInfo.Populate};

{ ------------------------------------------------------------------------------------------------ }
procedure TfrmInfoSentinel.PopulateProblems(const Sentinel: TZaapSentinelFile; const ClearFirst: Boolean);
var
  Line: string;
begin
  if ClearFirst then
    lvwFields.Clear;

  if Sentinel.HasProblem then begin
    lvwFields.Groups[1].State := lvwFields.Groups[1].State - [lgsHidden];
    for Line in Sentinel.Problem.Split([sLineBreak], TStringSplitOptions.ExcludeEmpty) do begin
      with lvwFields.Items.Add do begin
        GroupID := 1;
        SubItems.Add('');
        SubItems.Add(Line);
      end;
    end;
  end else begin
    lvwFields.Groups[1].State := lvwFields.Groups[1].State + [lgsHidden];
  end;
end {TfrmSentinelInfo.PopulateProblems};

end.
