﻿/*
The following built-in objects, methods and properties are always available for use in a script:

Built-in objects: 
	zbar {ZBarCOMLib.Zaap}
	File {Scripting.File}
	OtherFile {Scripting.File}
	FSO {Scripting.FileSystemObject}
Built-in methods:
	Alert(text)
	Confirm(text) {returns a boolean}
	CreateObject(progid) {returns the new ActiveX object}
	WriteLine(text)
	WriteText(text)
	Script.RegisterCommand(command) {returns a boolean}
	Script.RegisterKey(keycode, alt) {returns a boolean}
Built-in properties:
	Script.Output {string, read/write}
	Script.Name {string, read/write}
	Script.Filename {string, read-only}
*/


// We must tell the host which commands we want to process (otherwise, this script will not be called)
Script.RegisterCommand('pmatch');
if(Script.RegisterCommand('match') === false) {
	throw new Error('Unable to register our command...');
}

// The function called 'onAssist' will get called for each file when the Y or Ctrl-Y commands are 
//  invoked; it has one parameter, the command line entered by the user (less the starting 's').
function onAssist(command) {
	var match;
	// To use this specific script's functionality, enter 'smatch <regexp>' to tag the file if its name
	//  matches the regular expression, or untag it if it doesn't.
	if (match = /^(p)?match\s+(.*)$/.exec(command)) {
		var rexFile = new RegExp(match[2], 'i');
		if (match[1] === 'p') {
			return rexFile.test(file.Path);
		} else {
			return rexFile.test(file.Name);
		}
	}
}


// The function called 'onKeyPress' will get called whenever a Ctrl-Shift key combo is pressed in 
//  ZTreeWin.  To limit the number of calls, register one or more specific key combos, and the 
//  function will only be called for those key combos.

function onKeyPress(keycode, alt) {
	Write('You pressed Ctrl-Shift-');
	if (alt) {
		Write('Alt-');
	}
	WriteLine(String.fromCharCode(keycode) + ' (' + keycode + ') in ZTreeWin!');
}


// The function called 'onUpdate' will get called whenever the zbar.dat file gets updated;
//  it has one parameter: the zbar object provided by ZBarCOM.
/*
function onUpdate(zbar) {
	// see the ZBarCOM documentation for the properties of the ZBarCom object
	// (note that LogZBar and ReadZBar don't need to be called)
}
*/