﻿/*
The following built-in objects, methods and properties are always available for use in a script:

Built-in objects:
	zbar {ZBarCOMLib.Zaap}
	File {Scripting.File}
	OtherFile {Scripting.File}.
Built-in methods:
	Alert(text)
	WriteLine(text)
	WriteText(text)
Built-in properties:
	Output {string, read/write}
*/

// onAssist will get called for each file when the Y or Ctrl-Y commands are invoked;
//  it has one parameter, the zbar object provided by ZBarCOM
function onAssist(zbar) {
	var findText, findHex, findREx;
	var replacement = '';
	
	// react to the following commands:
	// replace 0d 0a by "..."
	// replace "..." by '...'
	// replace '...' by "..."
	// replace /regexp/ by "..."
	var rexReplace = /^replace (?:((?:[\da-f]{1,2}\s?)+)|(["'\/])([^\1]+)\1(gim?)) by (['"])"([^\5]*)\5$/i;
	var match = rexReplace.exec(zbar.AssistCommand);
	if (match) {
		if (match[4] !== '') { // it's a hex string
			findHex = match[4];
			
		} else switch(match[1]) {
			case '': // no delimiters, so it's a hex string
				findHex = match[4];
				break;
			case '"': case "'": // it's a text string
				findText = match[2];
				findREx = new RegExp(findText.replace(/\\/g, '\\\\'), match[3]);
				break;
			case '/': // it's a regular expression
				findREx = new RegExp(match[2], match[3]);
				break;
			default:
				throw new SyntaxError('Invalid search string!');
		}
		replacement = match[6];
	}
}

// onUpdate will get called whenever the zbar.dat file gets updated;
//  it has one parameter: the zbar object provided by ZBarCOM
/*
function onUpdate(zbar) {
	// see the ZBarCOM documentation for the properties of the ZBarCom object
	// (note that ReadZBar doesn't need to be called)
}
*/


// onKeyPress will get called whenever the user presses a Ctrl-Shift[-Alt]
//  key combination. The first argument contains the ASCII value of
//  the key that was pressed.  If Alt was pressed as well as Ctrl and Shift, 
//  then the second argument is True; otherwise it is false.
/*
function onKeyPress(charCode, alt) {
	// do whatever you want to do here... :-)
}
*/
