VERSION 5.00
Begin VB.Form frmMain 
   ClientHeight    =   2715
   ClientLeft      =   6675
   ClientTop       =   5970
   ClientWidth     =   3480
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "Main.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   2715
   ScaleWidth      =   3480
   Begin VB.CommandButton cmdTrackPath 
      Caption         =   "(track path)"
      Height          =   375
      Left            =   2280
      TabIndex        =   0
      Tag             =   "(track path)"
      Top             =   0
      Visible         =   0   'False
      Width           =   1095
   End
   Begin TitleChangerZAAP.ctlTrayIcon ctlTrayIcon 
      Left            =   120
      Top             =   120
      _ExtentX        =   847
      _ExtentY        =   847
      Icon            =   "Main.frx":030A
      ToolTipText     =   "ZTree Title Changer"
   End
   Begin VB.Menu mnuTray 
      Caption         =   "(tray)"
      Begin VB.Menu mnuTrayAbout 
         Caption         =   "&About..."
      End
      Begin VB.Menu mnuTrayBarAbout 
         Caption         =   "-"
      End
      Begin VB.Menu mnuTrayDebug 
         Caption         =   "&Debug"
      End
      Begin VB.Menu mnuTraySettings 
         Caption         =   "&Settings..."
      End
      Begin VB.Menu mnuTrayIcon 
         Caption         =   "Hide &icon"
      End
      Begin VB.Menu mnuTrayBarExit 
         Caption         =   "-"
      End
      Begin VB.Menu mnuTrayExit 
         Caption         =   "E&xit"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private istrIniFile As String

Private Sub Form_Load()
    cmdTrackPath.Caption = cmdTrackPath.Tag
    ctlTrayIcon.ToolTipText = App.Title
    
    ReadSettings
    
    Me.Visible = False
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    If Cancel = False Then
        modFileWatcher.StopWatching
        modZBar.StopTracking
        ctlTrayIcon.Visible = False
    End If
End Sub


Private Sub ctlTrayIcon_DblClick(ByVal plngButton As MouseButtonConstants)
    If plngButton = vbLeftButton Then
        mnuTraySettings_Click
    End If
End Sub

Private Sub ctlTrayIcon_MouseDown(ByVal plngButton As MouseButtonConstants)
    ctlTrayIcon.PopupMenu mnuTray, mnuTraySettings
End Sub

Private Sub mnuTrayAbout_Click()
    MsgBox App.Title & " v" & App.Major & "." & App.Minor & "." & App.Revision & vbCrLf & _
                " 2005-2007 Martijn Coppoolse" & vbCrLf & _
                vbCrLf & _
                "Visit the ZTree Wiki at http://www.ztwiki.com!" & vbCrLf & _
                "For bugs, requests, praise, or criticism, send e-mail to TitleChanger@martijn.coppoolse.com." & vbCrLf & _
                vbCrLf & _
                App.Path & IIf(Right$(App.Path, 1) = "\", "", "\") & App.EXEName & ".exe", _
           vbInformation
End Sub

Private Sub mnuTrayDebug_Click()
    modZBar.DebugMode = Not modZBar.DebugMode
    mnuTrayDebug.Checked = modZBar.DebugMode
End Sub

Private Sub mnuTrayIcon_Click()
    If MsgBox("Are you certain you want to hide the icon for " & App.Title & "?" & vbCrLf & _
              vbCrLf & _
              "(You can switch it back on by manually editing the file" & vbCrLf & _
              """" & istrIniFile & """)", _
              vbQuestion Or vbYesNo Or vbDefaultButton2, _
              App.Title) = vbYes Then
        ctlTrayIcon.Visible = False
        With New Settings
            .Location = INIFile
            
            modFileWatcher.StopWatching
            .Value("HideIcon", "General") = "yes"
            modFileWatcher.StartWatching istrIniFile, 5000, _
                                         Me, "ReadSettings", VbMethod, True
        End With
    End If
End Sub

Private Sub mnuTraySettings_Click()
    Dim lintFile As Integer
    
    lintFile = FreeFile()
    Open istrIniFile For Append As #lintFile
    Close #lintFile
    
    ShellExecute istrIniFile, , False
End Sub

Private Sub mnuTrayExit_Click()
    Unload Me
End Sub


' The button cmdTrackPath is invisible, but can be pressed by another instance
'  of this program (see modPrevInstance) to pass along paths to track
Private Sub cmdTrackPath_Click()
    Dim lstrItems() As String
    
    If cmdTrackPath.Caption <> cmdTrackPath.Tag Then
        lstrItems() = Split(cmdTrackPath.Caption, vbTab)
        If modZBar.StartTrackingPath(lstrItems(0), lstrItems(1), lstrItems(2), lstrItems(3)) Then
            ctlTrayIcon.ShowBalloon "Now also tracking " & GetLongPath(GetFullPath(lstrItems(0))) & "\zbar.dat.", _
                                    NIIF_INFO, App.Title, , False
        Else
            ctlTrayIcon.ShowBalloon GetLongPath(GetFullPath(lstrItems(0))) & "\zbar.dat was already being tracked.", _
                                    NIIF_WARNING, App.Title, , False
        End If
        cmdTrackPath.Caption = cmdTrackPath.Tag
    End If
End Sub


Public Sub ReadSettings(Optional ByVal ablnReload As Boolean = False)
    Dim lstrPath As String
    Dim lclsSettings As Settings
    Dim lstrPaths() As String
    Dim llngPath As Long
    Dim lstrFormatNormal As String
    Dim lstrFormatMax As String
    Dim lstrFormatMin As String
    
    ' Determine the ZBar.dat folder from the command line or our executable path
    If LenB(Command$) > 0 Then
        If LenB(Dir$(Trim$(Command$()), vbDirectory Or vbHidden)) > 0 Then
            lstrPath = Trim$(Command$())
        End If
    End If
    If LenB(lstrPath) = 0 Then
        lstrPath = App.Path
    End If
    
    Set lclsSettings = New Settings
    lclsSettings.Location = INIFile
    istrIniFile = lclsSettings.Filename
    
    ctlTrayIcon.Visible = True
    If ablnReload Then
        modZBar.StopTracking
        ctlTrayIcon.ShowBalloon "Settings reloaded", NIIF_INFO, App.Title, 2000, False
    End If
    
    Select Case LCase$(lclsSettings.Value("Debug", "General", "no"))
    Case "yes"
        mnuTrayDebug.Enabled = True
        mnuTrayDebug.Visible = True
        modZBar.DebugMode = True
    Case "allow"
        mnuTrayDebug.Enabled = True
        mnuTrayDebug.Visible = True
    Case Else
        mnuTrayDebug.Enabled = False
        mnuTrayDebug.Visible = False
        modZBar.DebugMode = False
    End Select
    mnuTrayDebug.Checked = modZBar.DebugMode
    
    modZBar.DefaultInterval = lclsSettings.Value("Interval", "General", 1000)
    
    Select Case lclsSettings.Value("TrustFileTime", "General", "no")
    Case "yes"
        modZBar.TrustFileTime = True
    Case Else
        modZBar.TrustFileTime = False
    End Select
    
    lstrFormatNormal = lclsSettings.Value("Normal", "Formatting", vbNullString)
    lstrFormatMax = lclsSettings.Value("Maximized", "Formatting", vbNullString)
    lstrFormatMin = lclsSettings.Value("Minimized", "Formatting", vbNullString)
    
    lstrPaths() = lclsSettings.Value(Empty, "Paths", Split(lstrPath, vbNullChar))
    If UBound(lstrPaths) < LBound(lstrPaths) Then
        lstrPaths() = Split(lstrPath, vbNullChar)
    End If
    If UBound(lstrPaths) >= LBound(lstrPaths) Then
        For llngPath = LBound(lstrPaths) To UBound(lstrPaths)
            If App.PrevInstance Then
                cmdTrackPath.Caption = vbNullString
                PassInfoToPrevInstance lstrPaths(llngPath) & vbTab & _
                                        lstrFormatNormal & vbTab & _
                                        lstrFormatMax & vbTab & _
                                        lstrFormatMin, _
                                       cmdTrackPath.Tag
                DoEvents
            Else
                modZBar.StartTrackingPath lstrPaths(llngPath), _
                                          lstrFormatNormal, _
                                          lstrFormatMax, _
                                          lstrFormatMin
            End If
        Next
    End If
    
    If App.PrevInstance Then
        Set lclsSettings = Nothing
        End
    End If
    
    ctlTrayIcon.Visible = (lclsSettings.Value("HideIcon", "General", "no") <> "yes")
    Set lclsSettings = Nothing
    
    If ablnReload = False Then
        ' Keep track of modifications in the settings file
        modFileWatcher.StartWatching istrIniFile, 10000, _
                                     Me, "ReadSettings", VbMethod, True
    End If
End Sub
